import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/presentation/components/buttons/animation_button_effect.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

import 'package:admin_desktop/presentation/styles/style.dart';

class NavigationItem extends StatelessWidget {
  final bool isActive;
  final bool titleActive;
  final String title;
  final IconData icon;
  final IconData selectIcon;
  final VoidCallback onTap;

  const NavigationItem({
    super.key,
    required this.onTap,
    required this.isActive,
    required this.icon,
    required this.selectIcon,
    required this.title,
    required this.titleActive,
  });

  @override
  Widget build(BuildContext context) {
    return ButtonEffectAnimation(
      onTap: onTap,
      child: Padding(
        padding: EdgeInsets.symmetric(vertical: 6),
        child: Row(
          mainAxisAlignment: titleActive
              ? MainAxisAlignment.start
              : MainAxisAlignment.spaceBetween,
          children: [
            Container(
              width: 6,
              height: 40,
              decoration: BoxDecoration(
                color: isActive ? Style.primary : Style.black,
                borderRadius: BorderRadius.only(
                  topRight: Radius.circular(10),
                  bottomRight: Radius.circular(10),
                ),
              ),
            ),
            4.horizontalSpace,
            isActive
                ? Icon(
                    selectIcon,
                    color: Style.primary,
                    size: 24,
                  )
                : Icon(
                    icon,
                    color: Style.white,
                    size: 24,
                  ),
            4.horizontalSpace,
            if (titleActive)
              Text(
                AppHelpers.getTranslation(title),
                style: isActive
                    ? Style.interSemi(size: 16, color: Style.primary)
                    : Style.interMedium(size: 16, color: Style.white),
              ),
          ],
        ),
      ),
    );
  }
}
